 aR  w / mP9      h	 oP      nSystem-wide$NOLIST

    NAME RotateFont

; This is RotatFnt.Asm.

CGROUP GROUP CODE


PUBLIC RotateFontImages


FontInfoType STRUC
	fiVers        DW ?
	fiFileSize    DW ?
	fiFileSizeHi  DB ?
	fiOrientation DB ?
	fiCopyright   DB 60 DUP (?)
	fiFntClass    DW ?
	fiPointSize   DW ?
	fiVertRes     DW ?
	fiHorizRes    DW ?
	fiBaseLine    DW ?
	fiIntLead     DW ?
	fiExtLead     DW ?
	fiItalic      DB ?
	fiUnderline   DB ?
	fiStrikeOut   DB ?
	fiWeight      DW ?
	fiCharSet     DB ?
	fiPixWidth    DW ?
	fiPixHeight   DW ?
	fiPitchFmly   DB ?
	fiAvgWidth    DW ?
	fiMaxWidth    DW ?
	fiFirstChar   DB ?
	fiLastChar    DB ?
	fiDfltChar    DB ?
	fiBreakChar   DB ?
	fiWidBytes    DW ?
	fiDevName     DD ?
	fiFaceName    DD ?
	fiSomething   DD ?
	fiBitsData    DD ?
	fiFiller      DB ?
	fiChInfBase   DB ?
FontInfoType ENDS


CODE SEGMENT BYTE PUBLIC 'CODE'
    ASSUME CS:CGROUP


; This routine rotates the font character images either to the left or to
; the right (depending on the parameter direction).  It is assumed that the
; destination for the font info has already been allocated.

; RotateFontImages: PROCEDURE (pSrcFontInfo, pDstFontInfo, direction) CLEAN
;  DCL pSrcFontInfo  PTR;
;  DCL pDstFontImage PTR;
;  DCL direction     BYTE;

pSrcFontInfo      EQU DWORD PTR [BP+12]
pDstFontInfo      EQU DWORD PTR [BP+08]
direction         EQU  BYTE PTR [BP+06]

curOrientation    EQU  BYTE PTR [BP-02]
pixelHeight       EQU  WORD PTR [BP-04]
imageHeight       EQU  WORD PTR [BP-06]
imageWidth        EQU  WORD PTR [BP-08]


RotateFontImages PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	SUB	SP, 8	; leave room on stack for local variables

	LDS	SI, pSrcFontInfo

	MOV	AL, DS:[SI].fiOrientation
	MOV	curOrientation, AL	; Save current orientation as a local

	MOV	AX, DS:[SI].fiPixHeight
	MOV	pixelHeight, AX	; Save font char height as a local

	MOV	AL, DS:[SI].fiLastChar
	SUB	AL, DS:[SI].fiFirstChar	; Num chars = (last - first) + 1 {+ 1}
	ADD	AL, 2	; There is always one extra image at the end
	MOV	AH, 0
	PUSH	AX	; Save num of chars to rotate for later

	MOV	BX, WORD PTR DS:[SI].fiBitsData

	MOV	DX, DS:[SI].fiFileSize	; Save total size of fontInfo in DX
	LES	DI, pDstFontInfo	; Destination of copy and zero fill
	MOV	CX, SIZE FontInfoType
	DEC	CX	; Don't count first byte of charInfo (base)
	MOV	AX, CX	; Save number of bytes being copied in AX
	SHR	CX, 1	; Move words since header is even
	CLD		; Copy words and increment pointer
	REP	MOVSW	; Do the copy

	PUSH	DI	; Save beginning of charInfo for destination

	SUB	DX, AX	; Bytes remaining in dest font info
	MOV	CX, DX
	XOR	AX, AX	; Fill with zeros
	SHR	CX, 1	; Fill by words
	REP	STOSW	; Do the filling
	JNC	NotOdd	; If even boundary then done

	STOSB	; Fill the last odd byte

NotOdd:
	POP	DI	; Beginning of charInfo for destination
	POP	CX	; Number of characters to rotate

ImageLoop:
	PUSH	BX	; Save next location for char bit info
	PUSH	CX	; Save number of char images left to rotate
	LODSW	; Source characters width
	STOSW	; Dest character width same even if rotated
	XCHG	CX, AX
	MOV	DX, pixelHeight
	LODSW	; Source char's image info offset
	XCHG	BX, AX	; BX=Src image info offset; AX=Dst image info
	STOSW	; Dest characters image info offset
	TEST	curOrientation, 1	; If current orientation is north or south
	JZ	OrientationIsNorthSouth	; then width and height are correct

	XCHG	CX, DX	; Exchange width and height

OrientationIsNorthSouth:
	MOV	imageWidth, CX
	MOV	imageHeight, DX

	PUSH	SI	; Next src char's width/image info offset
	PUSH	DI	; Next dst char's width/image info offset

	MOV	SI, BX
	ADD	SI, WORD PTR pSrcFontInfo
	MOV	DI, AX
	ADD	DI, WORD PTR pDstFontInfo

	MOV	BH, 80H	; Mask
	MOV	CH, 0	; Rotate base
	XOR	DX, DX	; Initialize src height position index

	TEST	direction, 1
	JNZ	RotateRight

RotateLeft:
	SUB	SI, imageHeight	; Back up to compensate for initial add
	DEC	DI	; Back up one to compensate for initial inc

LHeightLoop:
	PUSH	DX	; Save current height position index
	TEST	DL, 7	; If dest is not on a byte boundary then
	JNZ	LNotOnByteBoundary1	; don't need to increment destination ptr

	ADD	DI, imageWidth	; Increment destination ptr

LNotOnByteBoundary1:
	PUSH	DI	; Save destination ptr
	PUSH	SI	; Save source ptr

	XOR	DX, DX	; Initialize src width position index

LWidthLoop:
	TEST	DL, 7	; If source is not on a byte boundary then
	JNZ	LNotOnByteBoundary2	; don't need to get next source byte

	MOV	CL, CH	; Rotate amt = rotate amt base
	ADD	SI, imageHeight	; Next column
	MOV	BL, DS:[SI]	; Next source byte

LNotOnByteBoundary2:
	MOV	AL, BL	; Copy of source byte
	ROL	AL, CL	; Rotate into position
	AND	AL, BH	; Mask out bit of interest
	OR	ES:[DI], AL	; OR it into destination location

	DEC	DI	; Point to next destination byte
	INC	CL	; Increment rotate amount
	AND	CL, 7	; Keep it in the range from 0 to 7

	INC	DX	; Next src width position
	CMP	DX, imageWidth	; If haven't done entire width
	JB	LWidthLoop	; Then go back and do next

	ROR	BH, 1	; Rotate mask to get next line of bits
	DEC	CH	; Decrement the rotate amount base
	AND	CH, 7	; Keep it in the range from 0 to 7

	POP	SI	; Saved source ptr
	INC	SI	; Next row
	POP	DI	; Saved dest ptr

	POP	DX	; Current height position index
	INC	DX	; Next position
	CMP	DX, imageHeight	; If haven't done entire height
	JB	LHeightLoop	; Then go back and do next
	JMP	NextCharImage

RotateRight:
	DEC	SI	; Back up one to compensate for initial inc
	SUB	DI, imageWidth	; Back up to compensate for initial add

RHeightLoop:
	PUSH	DX	; Save current height position index
	TEST	DL, 7	; If dest is not on a byte boundary then
	JNZ	RNotOnByteBoundary1	; don't need to increment destination ptr

	ADD	DI, imageWidth	; Increment destination ptr

RNotOnByteBoundary1:
	PUSH	DI	; Save destination ptr
	PUSH	SI	; Save source ptr

	XOR	DX, DX	; Initialize src width position index

RWidthLoop:
	TEST	DL, 7	; If source is not on a byte boundary then
	JNZ	RNotOnByteBoundary2	; don't need to get next source byte

	MOV	CL, CH	; Rotate amt = rotate amt base
	ADD	SI, imageHeight	; Next column
	MOV	BL, DS:[SI]	; Next source byte

RNotOnByteBoundary2:
	MOV	AL, BL	; Copy of source byte
	ROL	AL, CL	; Rotate into position
	AND	AL, BH	; Mask out bit of interest
	OR	ES:[DI], AL	; OR it into destination location

	INC	DI	; Point to next destination byte
	INC	CL	; Increment rotate amount
	AND	CL, 7	; Keep it in the range from 0 to 7

	INC	DX	; Next src width position
	CMP	DX, imageWidth	; If haven't done entire width
	JB	RWidthLoop	; Then go back and do next

	ROR	BH, 1	; Rotate mask to get next line of bits
	DEC	CH	; Decrement the rotate amount base
	AND	CH, 7	; Keep it in the range from 0 to 7

	POP	SI	; Saved source ptr
	DEC	SI	; Next row
	POP	DI	; Saved dest ptr

	POP	DX	; Current height position index
	INC	DX	; Next position
	CMP	DX, imageHeight	; If haven't done entire height
	JB	RHeightLoop	; Then go back and do next

NextCharImage:
	POP	DI	; Next dst char's width/image info offset
	POP	SI	; Next src char's width/image info offset

	POP	CX	; Number of chars left
	POP	BX	; Next dest char's bit image info offset
	DEC	CX
	JZ	RotateFontImagesRet

	MOV	AX, imageHeight
	ADD	AX, 7
	SHR	AX, 1
	SHR	AX, 1
	SHR	AX, 1
	MOV	DX, imageWidth
	MUL	DL
	ADD	BX, AX
	JMP	ImageLoop

RotateFontImagesRet:
	MOV	SP, BP
	POP	BP
	POP	DS
	RET	10
RotateFontImages ENDP

PURGE pSrcFontInfo, pDstFontInfo, direction


CODE ENDS

    END
